clear all;clc;close all;
%Example file showing the equivelent isotropic conductivity reconstruction 
%using harmonic Bz and noniterative harmonic Bz algorithm.
%This code use to generate the figure 1 in submited paper at IEEE 
%transection on biomedical engineering.
%Data set uses,
%          1. dog_001
%Functions uses, 
%          1. mrci_harmonic_Bz.m
% Incase of forward solver we follw the below reference: Minhas et al, 

% The toolbox does not provide any functions for finite element mesh and
% solver. Therfore, to run this example you need to use your own forward
% solver and mesh generation software. The part related to the forward
% solver is therefore, commented.
%*************************************************************************%
%******************************Loading data*******************************%
%*************************************************************************%
path = pwd;
run ([path,'\path_defination.m']);
path = [path,'\Data\dog_001'];
load([path,'\MR']); load([path,'\Bz']);
load([path,'\Mask']); load([path,'\MaskDisplay']);
%*************************************************************************%
%***************************Imaging parameters****************************%
%*************************************************************************%
imSize  = size(Bz,1);   % imaging matrix size
Nslices = size(Bz,3);   % number of slices
E       = size(Bz,4);   % number of projection
FOV = 180;              % field of view in millimeter
SliceThickness = 3;     % slice thickness in millimeter
VoxelSize = [FOV/imSize,FOV/imSize,SliceThickness];
CurrAmpl = 40e-3;       % injected current amplitude
Algorithm = 'Noniterative Harmonic Bz';
%*************************************************************************%
%*********************** Input for forward solver ************************%
%*************************************************************************%
ElectrodeArea = 0.001412;
InjectionFaceNumber = [1,590;192,226];
%*************************************************************************%
%************* Conductivity reconstruction using Harmonic Bz *************%
%*************************************************************************%
if strcmpi(Algorithm,'harmonic bz')
    Mask = double(Mask~=0);
    t = tic;
    mkdir([path,'\',Algorithm]);
    Niter = 10;
    ths = 0.001;
    cnd  = zeros(imSize,imSize,Nslices,Niter);
%     Forward solver
%     Option.Type = 'Homogeneous'; Option.Value = num2str(1);
%     gradU = zeros(imSize,imSize,Nslices,2,E);
%     kk = 1;
%     while kk<=E
%         [~,ux,uy] = forward_solver(CurrAmpl,ElectrodeArea,....
%             InjectionFaceNumber(kk,:),VoxelSize,imSize,Nslices,path,Option);
%         gradU(:,:,:,1,kk) = ux; gradU(:,:,:,2,kk) = uy;
%         kk = kk+1;
%         clear ux uy uz;
%     end
%     clear kk Option;
    recon_parameters = reconstruction_parameters(Algorithm,...
        'VoxelSize',VoxelSize,'s0',1,'PixelSmoothFactor',1,'Lambda',3);
    for ns = 1:Nslices
        recon_parameters.Mask = Mask(:,:,ns);
        U = squeeze(gradU(:,:,ns,:,:)); B = squeeze(Bz(:,:,ns,:));
        cnd(:,:,ns,1) = mrci_harmonic_Bz(U,B,recon_parameters);
        clear U B ; recon_parameters.Mask = [];
    end
    clear kk gradU;
    
    if Niter >1
        err = zeros(1,Niter);
%         Forward solver
%         delete([path,'\DomainProperty.txt']);
%         DomainData = reshape(squeeze(cnd(:,:,:,1)),imSize,imSize,1,Nslices);
%         write_data3D(DomainData,VoxelSize,path,0.17);
%         Option.Type = 'Interpolation'; Option.Value = path;
%         clear DomainData;
%         gradU = zeros(imSize,imSize,Nslices,2,E);
%         kk = 1;
%         while kk<=E
%             [~,ux,uy] = forward_solver(CurrAmpl,ElectrodeArea,....
%                 InjectionFaceNumber(kk,:),VoxelSize,imSize,Nslices,path,Option);
%             gradU(:,:,:,1,kk) = ux; gradU(:,:,:,2,kk) = uy;
%             kk = kk+1;
%             clear ux uy uz;
%         end
%         clear kk; delete([path,'\DomainProperty.txt']);
        err(1) = relative_L2_difference(squeeze(cnd(:,:,:,1)),0.1*Mask);
        figure('color','white');
        plot(1,err(1),'o-.','LineWidth',1.5); hold on; drawnow;
        for i = 2:Niter
            for ns = 1:Nslices
                recon_parameters.Mask = Mask(:,:,ns);
                U = squeeze(gradU(:,:,kk,:,:)); B = squeeze(Bz(:,:,ns,:));
                cnd(:,:,ns,i) = mrci_harmonic_Bz(U,B,recon_parameters);
                clear U B ; recon_parameters.Mask = [];
            end
            clear kk gradU;
            delete([path,'\DomainProperty.txt']);
%           Forward solver
%             DomainData = reshape(squeeze(cnd(:,:,:,i)),imSize,imSize,1,Nslices);
%             write_data3D(DomainData,VoxelSize,path,0.17);
%             gradU = zeros(imSize,imSize,Nslices,2,E);
%             kk = 1;
%             while kk<=E
%                 [~,ux,uy] = forward_solver(CurrAmpl,ElectrodeArea,....
%                     InjectionFaceNumber(kk,:),VoxelSize,imSize,Nslices,path,Option);
%                 gradU(:,:,:,1,kk) = ux; gradU(:,:,:,2,kk) = uy;
%                 kk = kk+1;
%                 clear ux uy uz;
%             end
%             clear kk;
%             delete([path,'\DomainProperty.txt']);
            err(i) = mrci_relative_L2_difference(squeeze(cnd(:,:,:,i)),...
                squeeze(cnd(:,:,:,i-1)));
            plot(i,err(i),'o-.','LineWidth',1.5); hold on; drawnow;
            if err(i) > err(i-1)
                cnt = i-1;
                disp('Iteration stopped');
                clear gradU Option;
                break;
            end
            if err(i)<=ths
                cnt = i;
                disp('Iteration converged to the threshold limit');
                disp(['Iteration count ## ',num2str(cnt),'th!!!'])
                clear gradU Option;
                break;
            end
            if i == Niter
                cnt = Niter;
                disp('Iteration recahed to its maximum level');
                clear gradU Option;
            end
        end
        clear i;
        save([path,'\',Algorithm,'\Error'],'err');
        save([path,'\',Algorithm,'\Interation_count'],'cnt');
        cnd = cnd(:,:,:,1:cnt);
    end
    save([path,'\',Algorithm,'\Conductivity'],'cnd');
    clear Niter ths recon_parameters;
    t = toc(t)/60;
    disp(['Total processing time, ', num2str(t), ' min']);
    %*********************************************************************%
    %****************************** Results ******************************%
    %*********************************************************************%
    niter = cnt;
    x = 35:79; y = 40:89; z = 3:5;
    cndDisp = reshape(MaskDisplay(x,y,z).*squeeze(cnd(x,y,z,niter)),...
        length(x),length(y),1,length(z));
    figure('color','white'); montage(cndDisp,[0.70 1.15],'size',...
        [1,length(z)]);
    clear cndDisp x y z niter t;
end
