function u = mrci_poisson_solver2D(f,VoxelSize,bnd_val,Mask)
% This function is the part of magnetic resonance conductivity imaging (mrci)
% toolbox solving two dimesional Poisson's equation with drichlet boundary 
% condition using finite diference method (FDM).  i.e. is,
% \del^2 u = f on \Omega_t and u = u0 in \partial\Omega_t
% Writen by Saurav Z. K. Sajib, PhD. 
% Last date of modify [yyyy-mm-dd]: 2017-01-20.
% Copyright (C) to Impedance Imaging Research Center (IIRC).
% If you use this function please cite the below article:
% Sajib S. Z. K. et al, "Software Toolbox for Low-frequency Conductivity
% and Current Density Imaging using MRI," article submitted to IEEE Trans. Biomed. Eng.
% For any suggestion feel free to contact at iirc.mrci@gmail.com.

% Inputs of the function is,
% f[MN]: source term
% VoxelSize[13]: voxel size in meter.
% bnd_val[MN] or scaller: boundary condiction 
% Mask[MN]: region of interest.
% Output of the function,
% u[MN]: computed solution of the Poisson's equation

matsize = [size(Mask,1),size(Mask,2)];
VoxelSize = VoxelSize(1:2);
A = steinciel_matrix_2D(matsize);
f = prod(VoxelSize)*f(:);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Boundary nodes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mask_shirnk = imerode(Mask,strel('disk',1));
mask_bnd = Mask-mask_shirnk; 
bnd_val = mask_bnd.*bnd_val; bnd_val = bnd_val(:);%Change
[y,x] = find(mask_bnd==1);
LinearBndIdx = sub2ind(matsize,y,x);
clear mask_shirnk x y;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Exterior nodes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mask_exterior = double(Mask==0);
[y,x] = find(mask_exterior==1);
LinearExteriorIdx = sub2ind(matsize,y,x);
clear mask_exterior x y;
%%%%%%%%%%%%%%%% Solving the linear system for interior nodes %%%%%%%%%%%%%
bdNode  = zeros(prod(matsize),1);
extNode = zeros(prod(matsize),1);
u       = zeros(prod(matsize),1);
bdNode(LinearBndIdx,1) = 1;
bdNode = logical(bdNode);
extNode(LinearExteriorIdx,1) = 1;
extNode = logical(extNode);
clear LinearBndIdx LinearExteriorIdx;
freeNode = ~bdNode & ~extNode;
u(bdNode,1)  = bnd_val(bdNode);         %Change
u(extNode,1) = 0;
f = f-A*u;
u(freeNode) = A(freeNode,freeNode)\f(freeNode);
u = reshape(u,matsize);
end

function A = steinciel_matrix_2D(matsize)
A = zeros(matsize(1)*matsize(2),matsize(1)*matsize(2));
i = 2:matsize(1)-1;
for j = 2:matsize(2)-1
    row_idx      = sub2ind(matsize,i,j*ones(size(i)));
    col_idx(:,1) = sub2ind(matsize,i-1,j*ones(size(i)));
    col_idx(:,2) = sub2ind(matsize,i+1,j*ones(size(i)));
    col_idx(:,3) = sub2ind(matsize,i,(j-1)*ones(size(i)));
    col_idx(:,4) = sub2ind(matsize,i,(j+1)*ones(size(i)));
    col_idx(:,5) = sub2ind(matsize,i,j*ones(size(i)));
    kk = 1;
    while kk<=length(row_idx)
        A(row_idx(kk),col_idx(kk,1:4)) =  1;
        A(row_idx(kk),col_idx(kk,5))   = -4;
        kk = kk+1;
    end
    clear kk row_idx col_idx;
end
clear j i;
end