function  gft = mk_grad_ft(rho,imsize,size)
% This code is the part of the MRCI Toolbox used to calulate the gradient 
% Rceived from Prof. O. I. Kwon
% Date unknown 
gft=zeros(2,imsize,imsize);
tmp=gft;
xh=size/imsize;

for j=1:imsize-1
    for i=1:imsize-1
        for m=1:2
            tmp(m,i,j)=rho(i,j)*dpi2(m,1,1/2,1/2)/xh...
                +rho(i+1,j)*dpi2(m,2,1/2,1/2)/xh...
                +rho(i+1,j+1)*dpi2(m,3,1/2,1/2)/xh...
                +rho(i,j+1)*dpi2(m,4,1/2,1/2)/xh;
        end
    end
end

for j=2:imsize-1
    for i=2:imsize-1
        for m=1:2
            gft(m,i,j)=(tmp(m,i-1,j-1)+tmp(m,i,j-1)+...
                tmp(m,i,j)+tmp(m,i-1,j))/4;
        end
    end
end

















