function gft = mk_grad_ft3(rho,xsize,zsize,ith1,ith2)
% This code is the part of the MRCI Toolbox used to calulate the gradient 
% Rceived from Prof. O. I. Kwon
% Date unknown 
si=size(rho);
gft=zeros(3,si(1),si(2),si(3));
tmp=zeros(3,si(1),si(2),si(3));
xh=xsize/si(1);
zh=zsize/si(3);

for ith=ith1:ith2-1
    for j=1:si(1)-1
        for i=1:si(2)-1
            for m=1:3
                if(m==3)
                    xzh=zh;
                else
                    xzh=xh;
                end
                tmp(m,i,j,ith)=rho(i,j,ith)*dpi3(m,1,1/2,1/2,1/2)/xzh...
                    +rho(i+1,j,ith)*dpi3(m,2,1/2,1/2,1/2)/xzh...
                    +rho(i+1,j+1,ith)*dpi3(m,3,1/2,1/2,1/2)/xzh...
                    +rho(i,j+1,ith)*dpi3(m,4,1/2,1/2,1/2)/xzh...
                    +rho(i,j,ith+1)*dpi3(m,5,1/2,1/2,1/2)/xzh...
                    +rho(i+1,j,ith+1)*dpi3(m,6,1/2,1/2,1/2)/xzh...
                    +rho(i+1,j+1,ith+1)*dpi3(m,7,1/2,1/2,1/2)/xzh...
                    +rho(i,j+1,ith+1)*dpi3(m,8,1/2,1/2,1/2)/xzh;
            end
        end
    end
end

for ith=ith1+1:ith2-1
    for j=2:si(1)-1
        for i=2:si(2)-1
            for m=1:3
                gft(m,i,j,ith)=(tmp(m,i-1,j-1,ith)+tmp(m,i,j-1,ith)+...
                    tmp(m,i,j,ith)+tmp(m,i-1,j,ith))/4;
            end
        end
    end
end

















