function sigma = mrci_J_substitution(gradU,J,recon_parameters)
% This function is the part of magnetic resonance conductivity imaging (mrci)
% toolbox calulating the equivelent isotropic conductivity using J-substitution algorithm. 
% For details of the algorithm please see the below reference,
% Kwon O. I. et al. IEEE Trans Biomed. Eng., 49, 2002.  
% Writen by Saurav Z. K. Sajib, PhD. 
% Last date of modify [yyyy-mm-dd]: 2017-01-20.
% Copyright (C) to Impedance Imaging Research Center (IIRC).
% If you use this function please cite the below article:
% Sajib S. Z. K. et al, "Software Toolbox for Low-frequency Conductivity
% and Current Density Imaging using MRI," article submitted to IEEE Trans. Biomed. Eng.
% For any suggestion feel free to contact at iirc.mrci@gmail.com.

% Inputs of the function is,
% gradU[MN3E]: calculated two-dimensional gradient of voltage where,
% ux = squeeze(gradU(:,:,1,:));
% uy = squeeze(gradU(:,:,2,:)); 
% uz = squeeze(gradU(:,:,3,:));
% J[MN3E]: estimated current density images where,
% Jx = squeeze(J(:,:,1,:)); 
% Jy = squeeze(J(:,:,2,:)); 
% Jz = squeeze(J(:,:,3,:));
% recon_parameters.Mask[MN]: region of interest (optional).
% Output of the function is,
% sigma[MN]: reconstructed conductivity image.

%%%%%%%%%%%%%%%%%%%%%%%%%%% Checking the inputs %%%%%%%%%%%%%%%%%%%%%%%%%%%
if isempty(recon_parameters.Mask)
    Mask = double(squeeze(gradU(:,:,1,1))~=0);
else 
    Mask = recon_parameters.Mask;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%% Checking the inputs %%%%%%%%%%%%%%%%%%%%%%%%%%%
SizegradU = size(squeeze(gradU));
SizeJ = size(J);
if SizegradU ~= SizeJ
    error('Check the data size ([MN3E]).');
end
%%%%%%%%%%%%%%%%%%%%% Reconstructing the conductivity %%%%%%%%%%%%%%%%%%%%%
imSize    = size(Mask,1);
sigma  = zeros(imSize,imSize);
ux = squeeze(gradU(:,:,1,:)); 
uy = squeeze(gradU(:,:,2,:)); 
uz = squeeze(gradU(:,:,3,:));
clear gradU;
Jx = squeeze(J(:,:,1,:));  
Jy = squeeze(J(:,:,2,:));  
Jz = squeeze(J(:,:,3,:));
clear J;
for x = 1:imSize
    for y = 1:imSize
        if Mask(x,y) == 1
            gradU = [squeeze(ux(x,y,:)),squeeze(uy(x,y,:)),squeeze(uz(x,y,:))];
            J = [squeeze(Jx(x,y,:)),squeeze(Jy(x,y,:)),squeeze(Jz(x,y,:))]';
            dot_prod1 = gradU*J;
            dot_prod2 = gradU*gradU';
            dot_prod1 = diag(dot_prod1); dot_prod1 = sum(dot_prod1);
            dot_prod2 = diag(dot_prod2); dot_prod2 = sum(dot_prod2);
            tem = -(dot_prod1/dot_prod2);
            tem(isnan(tem)|isinf(tem)) = 0;
            sigma(x,y) = tem;
            clear gradU J dot_prod1 dot_prod2 tem;
        elseif Mask(x,y) == 0
            sigma(x,y) = 0;
        end
    end
    clear y;
end
clear x;

