function [x,y] = rearrange_points(x,y,flag)
% This function arrange points in CCW (flag=0) or CW (flag=1)
% Specially useful for boundary points arrangements
if nargin<3 || isempty(flag)
    flag = 0;
end

angle = atan2(y-mean(y),x-mean(x));
if flag == 0
    [~,orderIndx] = sort(angle,'ascend');
elseif flag == 1
    [~,orderIndx] = sort(angle,'descend');
end
x = x(orderIndx); y = y(orderIndx);
