clc;clear all;close all;

% This script performs pointwise group differences in cortical thicknesses
% for the right hemisphere
% modify as appropriate for left hemisphere

%group1 and group2 directory names
dirname1='C:\Users\ajoshi\Downloads\for_soyoung\Preterm';
dirname2='C:\Users\ajoshi\Downloads\for_soyoung\Term';

aa1=dir(dirname1);
aa1=aa1(3:end);
aa2=dir(dirname2);
aa2=aa2(3:end);

jjj=1;
npts=1000;
tar=readdfs('C:\Users\ajoshi\Documents\git_sandbox\svreg-matlab\HD_Atlas\mri.right.mid.cortex.dfs');


    for jj=1:length(aa1)
        subbasename=sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.dfs',dirname1,aa1(jj).name,aa1(jj).name);
        if ~exist(subbasename,'file')
            continue;
        end
        s=readdfs(subbasename);        
        s.attributes=smooth_surf_function(s,s.attributes);
        writedfs(sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.sm3p1.dfs',dirname1,aa1(jj).name,aa1(jj).name),s);
        fprintf('%d/%d smoothings done\n',jj,length(aa1));
    end
    for jj=1:length(aa2)
        subbasename=sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.dfs',dirname2,aa2(jj).name,aa2(jj).name);
        if ~exist(subbasename,'file')
            continue;
        end
        s=readdfs(subbasename);
        s.attributes=smooth_surf_function(s,s.attributes);
        writedfs(sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.sm3p1.dfs',dirname2,aa2(jj).name,aa2(jj).name),s);
        fprintf('%d/%d smoothings done\n',jj,length(aa1));
    end
for ptset=1:npts:length(tar.vertices)
    ptst1=ptset:min(ptset+npts-1,length(tar.vertices));clear Thickness1 Thickness2
    jj1=1;
    for jj=1:length(aa1)
        subbasename=sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.sm3p1.dfs',dirname1,aa1(jj).name,aa1(jj).name);
        s=readdfs(subbasename);
        Thickness1(:,jj)=s.attributes(ptst1);        jj1=jj1+1;
    end
    jj1=1;
    for jj=1:length(aa2)
        subbasename=sprintf('%s\\%s\\%s.target.right.mid.cortex.reg.sm3p1.dfs',dirname2,aa2(jj).name,aa2(jj).name);
        if ~exist(subbasename)
            continue;
        end
        s=readdfs(subbasename);
        Thickness2(:,jj1)=s.attributes(ptst1);        jj1=jj1+1;
    end
    Thickness1(:,13)=[];
    [h(ptst1),p(ptst1),~]=ttest2(Thickness1',Thickness2');
    
    disp(sprintf('%d/%d',ptset, length(tar.vertices)));
     
end

pfdr=FDR(p,0.05);

h=figure;
patch('vertices',tar.vertices,'faces',tar.faces,'facevertexcdata',1.1*(p'<0.05),'edgecolor','none','facecolor','interp');axis equal;axis off;camlight;material dull;lighting phong;
tar.vcolor=0*tar.vcolor;tar.vcolor(:,3)=1;
tar.vcolor(p<0.05,3)=0;tar.vcolor(p<0.05,1)=1;
writedfs('for_soyoung_right.dfs',tar);
saveas(h,'for_soyoung_right.fig');


