function Xfilt = Remove_Curve_Defects(X)

% Find interpoint distances to 3 forward neighbors
if isempty(X)
    Xfilt=X;
    return;
end
Nbrs = 3;
[X,~,~] = RemoveDuplicatePoints(X);
[X,~] = RemoveTraceOverDefects(X);

conn = 1;
i = 1;
while(i < size(X,2))
    Nbrs = min(3,size(X,2)-i);
    diffX = repmat(X(:,i),[1,Nbrs]) - X(:,i+1:i+Nbrs);
    dist = [];
    for j = 1:Nbrs
        dist(j) = norm(diffX(:,j));
    end
    [~,idx] = min(dist);
    conn = [conn,i+idx];
    if(idx > 1)
        i = i + idx;
    else
        i = i + 1;
    end
end
if isempty(X)
Xfilt = X;
else
Xfilt = X(:,conn);
end
return;
