% Copyright 2012 Anand A. Joshi, David W. Shattuck and Richard M. Leahy
% This file is part SVREG.

function generate_stats_xls_manual(subbasename,vol_lab,ROI_ID,surf_ext,output_ext,varargin)

% subbasename= %(subj1)
% label_ext= %(subbasename).labelext.'label.nii.gz
% ROI_ID= %[200,400,500]
% surf_ext=  %subbasename.left.mid.cortex.{surf_ext}


flags='';
for jj=1:size(varargin,2)
    flags=[flags,varargin{jj}];
end
%  flags=strrep(flags,'-','');
%  a=strfind(flags,'v');
if isempty(strfind(flags,'v'))
    verbosity=2;
else
    a=strfind(flags,'v');
    verbosity=flags(a(1)+1);   verbosity= str2double(verbosity);
end

labs=ROI_ID;
%l=readdfs([subbasename,'.tar.left.mid.cortex.reg.dfs']);
%r=readdfs([subbasename,'.tar.right.mid.cortex.reg.dfs']);
l=readdfs([subbasename,'.left.mid.cortex.',surf_ext]);
r=readdfs([subbasename,'.right.mid.cortex.',surf_ext]);
li=readdfs([subbasename,'.left.inner.cortex.',surf_ext]);
ri=readdfs([subbasename,'.right.inner.cortex.',surf_ext]);
lp=readdfs([subbasename,'.left.pial.cortex.',surf_ext]);
rp=readdfs([subbasename,'.right.pial.cortex.',surf_ext]);

        vl=load_nii(vol_lab);

%labs2=unique(vl.img(:));
%labs=unique(l.labels);labs=[labs2;labs;unique(r.labels)];labs=unique(labs);labs=sort(labs);labs(labs==0)=[];
%labs=reshape(labs,[length(labs),1]);
%labs=labs(labs>=100);
labs_sub=labs;
%labs=labs(labs<600);
ind=[];(labs_sub>=600)|(labs_sub<100);
labs_sub=labs_sub(ind);
labs(ind)=[];

th_roi=zeros(length(labs),1);
roi_area=th_roi;roi_area_inner=roi_area;roi_area_pial=roi_area;

for jj=1:length(labs)
    th_roi(jj)=mean([l.attributes(l.labels==labs(jj));r.attributes(r.labels==labs(jj))]);
    if labs(jj)>600 | labs(jj)==3
        th_roi(jj)=0;
    end
    % roi_id(jj)=labs(jj);
end
triL=tri_area(l.faces,l.vertices);
triR=tri_area(r.faces,r.vertices);
triLi=tri_area(li.faces,li.vertices);
triRi=tri_area(ri.faces,ri.vertices);
triLp=tri_area(lp.faces,lp.vertices);
triRp=tri_area(rp.faces,rp.vertices);

for jj=1:length(labs)
    if labs(jj)>600 || labs(jj)<100
    roi_area(jj)=0;
    roi_area_inner(jj)=0;
    roi_area_pial(jj)=0;
    roi_area(jj)=0;
    roi_area_inner(jj)=0;
    roi_area_pial(jj)=0;
    end
    tri_roi=find(((l.labels(l.faces(:,1))==labs(jj)) + (l.labels(l.faces(:,2))==labs(jj)) + (l.labels(l.faces(:,3))==labs(jj)))>=2);
    roi_area(jj)=sum(triL(tri_roi));
    roi_area_inner(jj)=sum(triLi(tri_roi));
    roi_area_pial(jj)=sum(triLp(tri_roi));
    
    tri_roi=find(((r.labels(r.faces(:,1))==labs(jj)) + (r.labels(r.faces(:,2))==labs(jj)) + (r.labels(r.faces(:,3))==labs(jj)))>=2);
    roi_area(jj)=roi_area(jj)+sum(triR(tri_roi));
    roi_area_inner(jj)=roi_area_inner(jj)+sum(triRi(tri_roi));
    roi_area_pial(jj)=roi_area_pial(jj)+sum(triRp(tri_roi));
    %roi_area(jj)=
end


vf=load_nii_z([subbasename,'.pvc.frac.nii']);

vgm.img=(vf.img>1).*double(1-abs(vf.img-2));
vcsf.img=(vf.img<2).*double(1-abs(vf.img-1));
vwm.img=(vf.img>2).*double(1-abs(vf.img-3));

gmv=zeros(length(labs),1);
csfv=zeros(length(labs),1);
wmv=zeros(length(labs),1);
totv=zeros(length(labs),1);

%if existfile([subbasename,'.svreg.corr.label.nii.gz']) || existfile([subbasename,'.svreg.label.nii.gz']) || existfile([subbasename,'.svreg.corr.manual.label.nii.gz'])
    for jj=1:length(labs)
        ind=(vl.img==labs(jj)); %=mean([l.attributes(l.labels==labs(jj));r.attributes(r.labels==labs(jj))]);
        gmv(jj)=sum(vgm.img(ind))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);
        csfv(jj)=sum(vcsf.img(ind))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);
        wmv(jj)=sum(vwm.img(ind))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);
        totv(jj)=wmv(jj)+gmv(jj);%sum(ind(:)>0)*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);
    end
 %   gmv(1:3)=0;wmv(1:3)=0;csfv(1:3)=0;
%     csfv(1)=sum(vcsf.img(:))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);totv(1)=csfv(1);
%     gmv(2)=sum(vgm.img(:))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);totv(2)=gmv(2);
%     wmv(3)=sum(vwm.img(:))*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);totv(3)=wmv(3);
    
    labs_vol=zeros(length(labs_sub),1);
    for jj=1:length(labs_sub)
        ind=find(vl.img==labs_sub(jj)); %=mean([l.attributes(l.labels==labs(jj));r.attributes(r.labels==labs(jj))]);
        labs_vol(jj)=length(ind)*vl.hdr.dime.pixdim(2)*vl.hdr.dime.pixdim(3)*vl.hdr.dime.pixdim(4);
        % roi_id(jj)=labs(jj);
    end
%end
th_roi(344)=0;
th_roi(345)=0;
th_roi(346)=0;
th_roi(347)=0;
    fp=fopen([subbasename,'.roiwise.',output_ext,'.stats.txt'],'w');

    
    fprintf(fp,'ROI_ID\tMean_Thickness(mm)\tGM_Volume(mm^3)\tCSF_Volume(mm^3)\tWM_Volume(mm^3)\tTotal_Volume(GM+WM)(mm^3)\tCortical_Area_mid(mm^2)\tCortical_Area_inner(mm^2)\tCortical_Area_pial(mm^2)\n');
    for jj=1:length(labs)
        fprintf(fp,'%d\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\n',labs(jj),th_roi(jj),gmv(jj),csfv(jj),wmv(jj),totv(jj),roi_area(jj),roi_area_inner(jj),roi_area_pial(jj));
    end

    %fprintf(fp,'ROI_ID\t ROI_Volume(mm^3)\n');
    for jj=1:length(labs_sub)
        fprintf(fp,'%d\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\n',labs_sub(jj),0,0,0,0,labs_vol(jj));
        %    fprintf(fp,'%d\t%.6f\n',labs_sub(jj),labs_vol(jj));
    end
fclose(fp);


