
function manual_correct_rois_stats(subbasename)
    atlasbasename=[subbasename,'.target'];
    if ~existfile([subbasename,'.svreg.corr.manual.label.nii.gz'])
        return;
    end
    v_manual=load_nii_z([subbasename,'.svreg.corr.manual.label.nii.gz']);
    
    v_auto=load_nii_z([subbasename,'.svreg.corr.label.nii.gz']);
    
    diff_labels=abs(v_manual.img-v_auto.img);
    ind=find(diff_labels);
    
    labs=zeros(size(v_auto.img));
    
    labs=[v_manual.img(ind);v_auto.img(ind)];
    labsind=find(labs);labs=labs(labsind);
    
    smid=readdfs([subbasename,'.right.mid.cortex.svreg.dfs']);
    sinner=readdfs([subbasename,'.right.inner.cortex.svreg.dfs']);
    spial=readdfs([subbasename,'.right.pial.cortex.svreg.dfs']);
    
    res=v_auto.hdr.dime.pixdim(2:4);
        
    X=(smid.vertices(:,1)/res(1)+1);Y=(smid.vertices(:,2)/res(2)+1);Z=(smid.vertices(:,3)/res(3)+1);
    
    tmplab=interp3(double(v_manual.img),Y,X,Z,'nearest');
    labs=unique(labs);
    [ia,ib]=ismember(smid.labels,labs);
    ia=find(ia);ib=find(ib);

    smid.labels(ia)=tmplab(ia);
    sinner.labels(ia)=smid.labels(ia);
    spial.labels(ia)=smid.labels(ia);
    
    writedfs([subbasename,'.right.mid.cortex.manual.svreg.dfs'],smid)
    corr_topology_labels([subbasename,'.right.mid.cortex.manual.svreg.dfs'],[subbasename,'.right.mid.cortex.manual.svreg.dfs']);
    recolor_by_label([subbasename,'.right.mid.cortex.manual.svreg.dfs'],atlasbasename);
    writedfs([subbasename,'.right.inner.cortex.manual.svreg.dfs'],sinner)
    corr_topology_labels([subbasename,'.right.inner.cortex.manual.svreg.dfs'],[subbasename,'.right.inner.cortex.manual.svreg.dfs']);
    recolor_by_label([subbasename,'.right.inner.cortex.manual.svreg.dfs'],atlasbasename);
    writedfs([subbasename,'.right.pial.cortex.manual.svreg.dfs'],spial);
    corr_topology_labels([subbasename,'.right.pial.cortex.manual.svreg.dfs'],[subbasename,'.right.pial.cortex.manual.svreg.dfs']);   
    recolor_by_label([subbasename,'.right.pial.cortex.manual.svreg.dfs'],atlasbasename);
    
    
    smid=readdfs([subbasename,'.left.mid.cortex.svreg.dfs']);
    sinner=readdfs([subbasename,'.left.inner.cortex.svreg.dfs']);
    spial=readdfs([subbasename,'.left.pial.cortex.svreg.dfs']);
    
    res=v_auto.hdr.dime.pixdim(2:4);
        
    X=(smid.vertices(:,1)/res(1)+1);Y=(smid.vertices(:,2)/res(2)+1);Z=(smid.vertices(:,3)/res(3)+1);
    
    tmplab=interp3(double(v_manual.img),Y,X,Z,'nearest');
    labs=unique(labs);
    [ia,ib]=ismember(smid.labels,labs);
    ia=find(ia);ib=find(ib);
    
    smid.labels(ia)=tmplab(ia);
    sinner.labels(ia)=smid.labels(ia);
    spial.labels(ia)=smid.labels(ia);
    
    writedfs([subbasename,'.left.mid.cortex.manual.svreg.dfs'],smid)
    corr_topology_labels([subbasename,'.left.mid.cortex.manual.svreg.dfs'],[subbasename,'.left.mid.cortex.manual.svreg.dfs']);
    recolor_by_label([subbasename,'.left.mid.cortex.manual.svreg.dfs'],atlasbasename);
    writedfs([subbasename,'.left.inner.cortex.manual.svreg.dfs'],sinner);
    corr_topology_labels([subbasename,'.left.inner.cortex.manual.svreg.dfs'],[subbasename,'.left.inner.cortex.manual.svreg.dfs']);
    recolor_by_label([subbasename,'.left.inner.cortex.manual.svreg.dfs'],atlasbasename);
    writedfs([subbasename,'.left.pial.cortex.manual.svreg.dfs'],spial);
    corr_topology_labels([subbasename,'.left.pial.cortex.manual.svreg.dfs'],[subbasename,'.left.pial.cortex.manual.svreg.dfs']);
    recolor_by_label([subbasename,'.left.pial.cortex.manual.svreg.dfs'],atlasbasename);
   
    generate_stats_xls(subbasename);
    
    