function make_atlas(subbasename,atlasbasename)
% This function prepares the subject to be used as a new atlas

movefile([subbasename,'.left.inner.cortex.svreg.dfs'],[subbasename,'.left.inner.cortex.dfs']);
movefile([subbasename,'.left.mid.cortex.svreg.dfs'],[subbasename,'.left.mid.cortex.dfs']);
movefile([subbasename,'.left.pial.cortex.svreg.dfs'],[subbasename,'.left.pial.cortex.dfs']);

movefile([subbasename,'.right.inner.cortex.svreg.dfs'],[subbasename,'.right.inner.cortex.dfs']);
movefile([subbasename,'.right.mid.cortex.svreg.dfs'],[subbasename,'.right.mid.cortex.dfs']);
movefile([subbasename,'.right.pial.cortex.svreg.dfs'],[subbasename,'.right.pial.cortex.dfs']);

smooth_surf_hierarchy([subbasename,'.right.mid.cortex.dfs'],10);
smooth_surf_hierarchy([subbasename,'.left.mid.cortex.dfs'],10);


 for jj=1:10
     s=readdfs(sprintf('%s.left.mid.cortex_smooth%d.dfs',subbasename,jj));
     s1.vertices=s.vertices;s1.attributes=s.attributes;s1.faces=[];
     writedfs(sprintf('%s.left.mid.cortex_smooth%d.dfs',subbasename,jj),s1);

     s=readdfs(sprintf('%s.right.mid.cortex_smooth%d.dfs',subbasename,jj));
     s1.vertices=s.vertices;s1.attributes=s.attributes;s1.faces=[];
     writedfs(sprintf('%s.right.mid.cortex_smooth%d.dfs',subbasename,jj),s1);     
 end
 
 [atpth,atb]=fileparts(atlasbasename);
 [subpth,sb]=fileparts(subbasename);
 
 copyfile([atpth,filesep,'*.mat'],subpth);
 copyfile([atpth,filesep,'*.xml'],subpth);
 copyfile([subbasename,'.left.mapped.dfc'],[subbasename,'.left.dfc']);
 copyfile([subbasename,'.right.mapped.dfc'],[subbasename,'.right.dfc']);
 copyfile([subbasename,'.svreg.corr.label.nii.gz'],[subbasename,'.label.nii.gz'])
 
 

