% fname is a file with extension .nii
% The function first checks if .nii file exists, if yes then it reads it. If
% no then it tries to loads .nii.gz file

function v=load_nii_z(fname)

if strcmp(fname(end-2:end),'.gz')
    fname=fname(1:end-3);
    %error('File extension sent in is not nii! exiting..')
end

if strcmp(fname(end-3:end),'nii')
    error('File extension sent in is not nii! exiting..')
end

if exist(fname,'file')
    v=load_nii(fname, [], [], [], [], [], 1);
elseif exist([fname,'.gz'],'file')
    gunzip([fname,'.gz']);
    v=load_nii(fname, [], [], [], [], [], 1);
    %v=read_nifti_gz([fname,'.gz']);
    delete(fname);
else
    error('file doesn''t exist. exiting');
end
