% Copyright 2012 Anand A. Joshi, David W. Shattuck and Richard M. Leahy
% This file is part SVREG.
%
% SVREG is free software: you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SVREG is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.
%
% You should have received a copy of the GNU Lesser General Public License
% along with SVREG.  If not, see <http://www.gnu.org/licenses/>.
function recolor_by_label(surfn,atlas_name,xmlf)

surf1=readdfs(surfn);
a=fileparts(atlas_name);
if ~exist('xmlf','var')
if exist(fullfile(a,'brainsuite_labeldescription.xml'),'file')
    xmlfname=fullfile(a,'brainsuite_labeldescription.xml');
else
    xmlfname=[atlas_name,'brainsuite_labeldescription.xml'];
end
xmlf=xmlfname;
end
aaa=xml2struct(xmlf);

for kk=1:1:length(aaa.Children)
    if isempty(aaa.Children(kk).Attributes)% | length(aaa.Children(kk).Attributes(1).Value)<8
        % disp('h');
        continue;
    end
    cl=aaa.Children(kk).Attributes(1).Value;
    clr{kk}=dec2hex(hex2dec(cl(3:end)),6);
    id(kk)=str2num(aaa.Children(kk).Attributes(3).Value);
end

lab=sort(unique(surf1.labels));
lab=setdiff(lab,0);

for l1=1:length(lab)
    l=lab(l1);iii=find(id==l);
    if isempty(iii)
        continue;
    end
    id1=iii(1);
    surf1.vcolor(surf1.labels==l,3)=hex2dec(clr{id1}(5:6))/256;
    surf1.vcolor(surf1.labels==l,2)=hex2dec(clr{id1}(3:4))/256;
    surf1.vcolor(surf1.labels==l,1)=hex2dec(clr{id1}(1:2))/256;
    
end
surf1.vcolor(surf1.labels==0,1)=.5;
surf1.vcolor(surf1.labels==0,2)=.5;
surf1.vcolor(surf1.labels==0,3)=.5;
writedfs(surfn,surf1);
