function T=tractconnect(tractFile,varargin)
% Please see the document file for detail

tic;

addpath('./mfiles');

allTracts=readdfc_sipi(tractFile);
allTractNum=length(allTracts);
fprintf('Load tract file successfully\n');

doPvc=0;
doROI='nROI';
doLabel=0;
dataNum=0;
doDesc=0;
maxROI=0;

for i=1:nargin-1
    if strcmp(varargin{i},'--label')
        labelFile=load_untouch_nii(varargin{i+1});
        doLabel=1;
        resI=labelFile.hdr.dime.pixdim(2:4);
        tmpFile=labelFile;
        tmpName=varargin{i+1};
    end;
    if strcmp(varargin{i},'--data')
        dataNum=dataNum+1;
        dataFile{dataNum}=load_untouch_nii(varargin{i+1});
        dataName{dataNum}=varargin{i+1}(1:strfind(varargin{i+1},'.nii'));
        resD=dataFile{dataNum}.hdr.dime.pixdim(2:4);
        if doLabel~=1
            tmpFile=dataFile{dataNum};
            tmpName=varargin{i+1};
        end;
    end;
    if strcmp(varargin{i},'--desc')
        descFile=xmlread(varargin{i+1});
        doDesc=1;
        tmpName=varargin{i+1};
    end;
    if strcmp(varargin{i},'--pvc')
        pvcFile=load_untouch_nii(varargin{i+1});
        doPvc=1;
    end;
    if strcmp(varargin{i},'--noROI')
        doROI='nROI';
    end;
    if strcmp(varargin{i},'--patternROI')
        for j=i+1:nargin-1
            if strcmp(varargin{j}(1),'-')==1
                break;
            end;
            ROIPattern{j-i}=varargin{j};
        end;
        doROI='pROI';
    end;
    if strcmp(varargin{i},'--allROI')
        doROI='aROI';
    end;
end;

maskFile=tmpFile;
maskFile.hdr.dime.datatype=2;
countFile=tmpFile;
countFile.hdr.dime.datatype=16;
resT=tmpFile.hdr.dime.pixdim(2:4);
if doPvc~=1
    pvcFile=tmpFile;
    pvcFile.img(:,:,:)=3;
end;

if strcmp(doROI,'aROI')
    labelNum=descFile.getElementsByTagName('label').getLength;
    ROIPattern={};
    tmp=0;
    for ii=1:labelNum
        if str2num(descFile.getElementsByTagName('label').item(ii-1).getAttribute('id'))~=0
            for jj=ii:labelNum
                tmp=tmp+1;
                ROIPattern{tmp}=strcat(num2str(str2num(descFile.getElementsByTagName('label').item(ii-1).getAttribute('id'))),'&',num2str(str2num(descFile.getElementsByTagName('label').item(jj-1).getAttribute('id'))));
            end;
        end;
    end;
    maxROI=str2double(descFile.getElementsByTagName('label').item(labelNum-1).getAttribute('id'));
end;

if doDesc==1
    id2Item=zeros(maxROI+1,1);
    for ii=1:descFile.getElementsByTagName('label').getLength
        id2Item(str2double(descFile.getElementsByTagName('label').item(ii-1).getAttribute('id'))+1)=ii;
    end;
end;

if ~strcmp(doROI,'nROI')
    maxROI=max(maxROI,max(max(max(labelFile.img))));
    tractROI=zeros(allTractNum,maxROI);
    for ii=1:allTractNum
        for jj=1:length(allTracts{ii})
            xx=round(allTracts{ii}(jj,1)./resI(1))+1;
            yy=round(allTracts{ii}(jj,2)./resI(2))+1;
            zz=round(allTracts{ii}(jj,3)./resI(3))+1;
            if labelFile.img(xx,yy,zz)>0
                tractROI(ii,labelFile.img(xx,yy,zz))=1;
            end;
        end;
    end;
end;

if strcmp(doROI,'nROI')
    ROIPattern={'true'};
    tractROI=ones(allTractNum,1);
end;
fprintf('Load arguments succesfully\n');

resultFile=fopen('result.csv','wt');
csvTitle={'ROIs','tractNum','voxelNum'};
for ii=1:dataNum
    csvTitle=[csvTitle,{strcat(dataName{ii},'Min'),strcat(dataName{ii},'Avg'),strcat(dataName{ii},'Med'),strcat(dataName{ii},'Max'),strcat(dataName{ii},'Std')}];
end;
fprintf(resultFile,'%s,',csvTitle{:});
fprintf(resultFile,'\n');

fprintf('Calculating connectivity\n');
for ii=1:length(ROIPattern)
    ii;
    nowTracts=cell(0);
    maskFile.img(:,:,:)=0;
    countFile.img(:,:,:)=0;
    fileName='';
    
    tmpPattern=ROIPattern{ii};
    tmpExpression=regexprep(tmpPattern,'\d+','varMatrix(:,$0)');
    tmpExpression=strcat('@(varMatrix) ',tmpExpression);
    tmpFunc=str2func(tmpExpression);
    tmpResult=tmpFunc(tractROI);
    
    nowTracts=allTracts(tmpResult);
    
    fileName=ROIPattern{ii};
    if strcmp(doROI,'nROI')
        fileName=tractFile;
        nowTracts=allTracts;
    end;
    fileName=strrep(fileName,'&',' and ');
    fileName=strrep(fileName,'|',' or ');
    fileName=strrep(fileName,'~',' not ');
    
    if ~strcmp(doROI,'nROI')
        writedfc(strcat(fileName,'.dft'),nowTracts,tmpName);
    end;
    
    for jj=1:length(nowTracts)
        for kk=1:length(nowTracts{jj})
            xx=round(nowTracts{jj}(kk,1)./resT(1))+1;
            yy=round(nowTracts{jj}(kk,2)./resT(2))+1;
            zz=round(nowTracts{jj}(kk,3)./resT(3))+1;
            if pvcFile.img(xx,yy,zz)>2.5
                if countFile.img(xx,yy,zz)<1023
                    countFile.img(xx,yy,zz)=countFile.img(xx,yy,zz)+1;
                end;
            end;
        end;
    end;
    maskFile.img(countFile.img>0)=255;
    
    save_untouch_nii(maskFile,strcat(fileName,'.mask.nii.gz'));
    save_untouch_nii(countFile,strcat(fileName,'.count.nii.gz'));    
    
    fprintf(resultFile,'%s',strcat(fileName,','));
    csvData={};
    csvData{1}=length(nowTracts);csvData{2}=nnz(maskFile.img);
    for jj=1:dataNum
        dataTmp=dataFile{jj}.img(maskFile.img>0);
        csvData=[csvData,{min(dataTmp),mean(dataTmp),median(dataTmp),max(dataTmp),std(dataTmp)}];
    end;
    fprintf(resultFile,'%f,',csvData{:});
    fprintf(resultFile,'\n');

end;
fprintf('Calculation done and saved succesfully\n');

toc
T=1;
end

